<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مصمم السراير الاحترافي | تجربة واقعية</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <style>
        :root { --soft-blue: #f8fafc; --deep-blue: #0d6efd; --accent-color: #3b82f6; }
        body { background-color: #f1f5f9; font-family: 'Cairo', sans-serif; }
        
        .main-card { 
            background: white; border-radius: 32px; overflow: hidden; 
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); 
            border: none; min-height: 650px;
        }

        /* منطقة المعاينة المتطورة */
        .preview-area { 
            background: #ffffff;
            background-image: radial-gradient(#e2e8f0 1px, transparent 1px);
            background-size: 20px 20px; /* خلفية منقطة خفيفة لتعزيز العمق */
            display: flex; align-items: center; justify-content: center; 
            min-height: 600px; position: relative; padding: 40px; 
            overflow: hidden; cursor: crosshair;
        }

        #bed-render { 
            max-width: 90%; height: auto; 
            filter: drop-shadow(0 25px 30px rgba(0,0,0,0.12));
            transition: transform 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 0.4s ease;
            z-index: 5;
        }

        .options-area { padding: 40px; border-left: 1px solid #f1f5f9; background: #fff; }
        
        /* تصميم الأقمشة الجديد */
        .fabric-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 12px; }
        .fabric-item { 
            cursor: pointer; border: 2px solid #f1f5f9; border-radius: 18px; 
            padding: 4px; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            text-align: center; position: relative;
        }
        .fabric-item:hover { transform: translateY(-3px); border-color: #cbd5e1; }
        .fabric-item.active { 
            border-color: var(--deep-blue); 
            background: #eff6ff;
            box-shadow: 0 10px 15px -3px rgba(59, 130, 246, 0.2);
        }
        .fabric-item.active::after {
            content: "✓"; position: absolute; top: -5px; left: -5px;
            background: var(--deep-blue); color: white; width: 22px; height: 22px;
            border-radius: 50%; font-size: 12px; display: flex; align-items: center; justify-content: center;
        }
        .fabric-img { width: 100%; aspect-ratio: 1/1; object-fit: cover; border-radius: 14px; }

        /* Loader محسن */
        .loader-overlay { 
            position: absolute; inset: 0; background: rgba(255,255,255,0.7); 
            display: none; align-items: center; justify-content: center; 
            z-index: 20; backdrop-filter: blur(8px); 
        }

        /* تحسين السلايدر */
        .custom-range::-webkit-slider-thumb { background: var(--deep-blue); border: 3px solid #fff; box-shadow: 0 2px 5px rgba(0,0,0,0.2); }

        .btn-action { transition: 0.3s; border-radius: 14px; font-weight: 700; padding: 12px 24px; }
        .btn-action:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
    </style>
</head>
<body>

<div class="container py-5">
    <div class="row main-card g-0">
        
        <div class="col-lg-4 d-flex flex-column">
            <div class="options-area flex-grow-1">
                <div class="d-flex align-items-center mb-4">
                    <div class="bg-primary rounded-3 p-2 me-3 text-white">
                        <svg width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"></path></svg>
                    </div>
                    <h4 class="fw-bold m-0">استوديو التصميم</h4>
                </div>

                <label class="small fw-bold text-muted mb-2">موديل السرير</label>
                <select id="bed-select" class="form-select form-select-lg mb-4 border-2 shadow-none rounded-4">
                    <?php
                    $beds = $pdo->query("SELECT * FROM beds")->fetchAll();
                    foreach ($beds as $bed) echo "<option value='{$bed['id']}'>{$bed['name']}</option>";
                    ?>
                </select>

                <label class="small fw-bold text-muted mb-2">اختر القماش</label>
                <div class="fabric-grid mb-4">
                    <?php
                    $fabrics = $pdo->query("SELECT * FROM fabrics")->fetchAll();
                    foreach ($fabrics as $index => $fabric) {
                        $active = ($index === 0) ? 'active' : '';
                        echo "
                        <div class='fabric-item $active' data-id='{$fabric['id']}'>
                            <img src='{$fabric['texture_path']}' class='fabric-img'>
                            <div class='small mt-1 text-truncate fw-bold'>{$fabric['name']}</div>
                        </div>";
                    }
                    ?>
                </div>

                <div class="p-3 bg-light rounded-4 mb-4">
                    <label class="small fw-bold d-flex justify-content-between">
                        <span>قوة الظلال</span>
                        <span id="op-val">100%</span>
                    </label>
                    <input type="range" class="form-range custom-range" id="opacity-slider" min="0" max="100" value="100">
                    
                    <label class="small fw-bold d-flex justify-content-between mt-3">
                        <span>سطوع الإضاءة</span>
                        <span id="br-val">100%</span>
                    </label>
                    <input type="range" class="form-range custom-range" id="brightness-slider" min="50" max="150" value="100">
                </div>
            </div>
            
            <div class="p-4 border-top">
                <div class="row g-2">
                    <div class="col-6">
                        <button class="btn btn-outline-secondary w-100 btn-action" onclick="window.print()">🖨️ طباعة</button>
                    </div>
                    <div class="col-6">
                        <button class="btn btn-primary w-100 btn-action" id="btn-download">💾 حفظ</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-8 preview-area" id="zoom-container">
            <div class="loader-overlay" id="loader">
                <div class="text-center">
                    <div class="spinner-grow text-primary mb-3"></div>
                    <div class="fw-bold h5">يتم المعالجة الآن...</div>
                    <div class="small text-muted">تنسيق الألوان والذكاء الاصطناعي</div>
                </div>
            </div>
            <img id="bed-render" src="" alt="السرير المختار">
            
            <div class="position-absolute top-0 start-0 m-4">
                <span class="badge bg-white text-dark shadow-sm p-2 px-3 border rounded-pill">
                    🔍 حرك الماوس فوق السرير لمعاينة التفاصيل
                </span>
            </div>
        </div>

    </div>
</div>

<script>
    const render = document.getElementById('bed-render');
    const loader = document.getElementById('loader');
    const zoomContainer = document.getElementById('zoom-container');

    function updateResult() {
        const bedId = document.getElementById('bed-select').value;
        const activeFabric = document.querySelector('.fabric-item.active');
        const fabricId = activeFabric ? activeFabric.dataset.id : 1;
        const op = document.getElementById('opacity-slider').value;
        const br = document.getElementById('brightness-slider').value;

        // تحديث الأرقام المعروضة
        document.getElementById('op-val').innerText = op + '%';
        document.getElementById('br-val').innerText = br + '%';

        loader.style.display = 'flex';
        render.style.opacity = '0.3';

        const url = `process.php?bed_id=${bedId}&fabric_id=${fabricId}&opacity=${op}&brightness=${br}&v=${new Date().getTime()}`;
        
        const img = new Image();
        img.src = url;
        img.onload = () => {
            render.src = url;
            render.style.opacity = '1';
            loader.style.display = 'none';
        };
    }

    // نظام زوم متطور وسلس
    zoomContainer.addEventListener('mousemove', (e) => {
        if(loader.style.display === 'flex') return; // لا تعمل الزوم أثناء التحميل
        
        const rect = zoomContainer.getBoundingClientRect();
        const x = ((e.clientX - rect.left) / rect.width) * 100;
        const y = ((e.clientY - rect.top) / rect.height) * 100;
        
        render.style.transformOrigin = `${x}% ${y}%`;
        render.style.transform = "scale(2)";
    });

    zoomContainer.addEventListener('mouseleave', () => {
        render.style.transform = "scale(1)";
    });

    // المستمعات
    document.getElementById('bed-select').onchange = updateResult;
    document.getElementById('opacity-slider').oninput = updateResult;
    document.getElementById('brightness-slider').oninput = updateResult;
    
    document.querySelectorAll('.fabric-item').forEach(f => {
        f.onclick = function() {
            document.querySelectorAll('.fabric-item').forEach(el => el.classList.remove('active'));
            this.classList.add('active');
            updateResult();
        }
    });

    document.getElementById('btn-download').onclick = () => {
        const a = document.createElement('a');
        a.href = render.src;
        a.download = `Design-${new Date().getTime()}.png`;
        a.click();
    };

    // التشغيل الأول
    window.onload = updateResult;
</script>
</body>
</html>