<?php
// إيقاف إظهار الأخطاء لضمان نظافة دفق الصورة
ini_set('display_errors', 0);
error_reporting(E_ALL);

include 'db.php';

// استقبال المعاملات
$bed_id    = (int)($_GET['bed_id'] ?? 1);
$fabric_id = (int)($_GET['fabric_id'] ?? 1);
$opacity   = isset($_GET['opacity']) ? (int)$_GET['opacity'] : 100;
$brightness = isset($_GET['brightness']) ? (int)$_GET['brightness'] : 100;

try {
    // 1. جلب البيانات
    $stmt = $pdo->prepare("SELECT * FROM beds WHERE id = ?");
    $stmt->execute([$bed_id]);
    $bed = $stmt->fetch();

    $stmt = $pdo->prepare("SELECT * FROM fabrics WHERE id = ?");
    $stmt->execute([$fabric_id]);
    $fabric = $stmt->fetch();

    if (!$bed || !$fabric) throw new Exception("Data not found");

    // 2. تحميل صورة الهيكل والظلال
    $baseFrame = new Imagick(realpath($bed['frame_path']));
    $w = $baseFrame->getImageWidth();
    $h = $baseFrame->getImageHeight();

    // 3. تجهيز طبقة القماش مع ميزة المرايا (Mirroring)
    $tile = new Imagick(realpath($fabric['texture_path']));
    $tile->setImageVirtualPixelMethod(Imagick::VIRTUALPIXELMETHOD_MIRROR);
    
    $fabricLayer = new Imagick();
    $fabricLayer->newImage($w, $h, new ImagickPixel('none')); 
    $fabricLayer = $fabricLayer->textureImage($tile);

    // --- ميزة السطوع ---
    if ($brightness != 100) {
        // تعديل السطوع دون التأثير على جودة الألوان الأساسية
        $fabricLayer->modulateImage($brightness, 100, 100);
    }

    // 4. معالجة القناع (Mask) مع تنعيم خفيف للحواف
    $mask = new Imagick(realpath($bed['mask_path']));
    $mask->resizeImage($w, $h, Imagick::FILTER_LANCZOS, 1);
    $mask->blurImage(1, 0.5); 
    
    // قص القماش على شكل السرير
    $fabricLayer->compositeImage($mask, Imagick::COMPOSITE_DSTIN, 0, 0);

    // 5. الرندر الطبقي المتقدم للواقعية
    $overlay = clone $baseFrame;
    if ($opacity < 100) {
        $overlay->evaluateImage(Imagick::EVALUATE_MULTIPLY, $opacity / 100, Imagick::CHANNEL_ALPHA);
    }

    // دمج الظلال العميقة (Multiply)
    $fabricLayer->compositeImage($overlay, Imagick::COMPOSITE_MULTIPLY, 0, 0);
    
    // دمج الإضاءة المحيطة (SoftLight) لبروز النسيج
    $fabricLayer->compositeImage($overlay, Imagick::COMPOSITE_SOFTLIGHT, 0, 0);

    // 6. المخرجات النهائية
    $fabricLayer->setImageFormat('png');
    $fabricLayer->stripImage(); // تقليل الحجم لسرعة التحميل
    
    header("Content-Type: image/png");
    echo $fabricLayer->getImageBlob();

    // تنظيف الذاكرة
    $baseFrame->destroy(); $tile->destroy(); $mask->destroy(); $fabricLayer->destroy(); $overlay->destroy();

} catch (Exception $e) {
    header("HTTP/1.1 500 Internal Server Error");
}