<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>
<?php
// الاتصال بقاعدة البيانات (يفضل وضعه في ملف منفصل db.php واستدعاؤه)
include 'db.php'; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $type = $_POST['type']; // هل المرفوع سرير أم قماش؟
    $name = $_POST['name'];
    
    if ($type == 'bed') {
        // رفع صورة الإطار وصورة القناع
        $frame_path = 'assets/beds/' . basename($_FILES['frame']['name']);
        $mask_path  = 'assets/masks/' . basename($_FILES['mask']['name']);
        
        if (move_uploaded_file($_FILES['frame']['tmp_name'], $frame_path) && 
            move_uploaded_file($_FILES['mask']['tmp_name'], $mask_path)) {
            
            $stmt = $pdo->prepare("INSERT INTO beds (name, frame_path, mask_path) VALUES (?, ?, ?)");
            $stmt->execute([$name, $frame_path, $mask_path]);
            echo "✅ تم إضافة السرير بنجاح!";
        }
    } 
    elseif ($type == 'fabric') {
        // رفع صورة القماش
        $texture_path = 'assets/fabrics/' . basename($_FILES['texture']['name']);
        
        if (move_uploaded_file($_FILES['texture']['tmp_name'], $texture_path)) {
            $stmt = $pdo->prepare("INSERT INTO fabrics (name, texture_path) VALUES (?, ?)");
            $stmt->execute([$name, $texture_path]);
            echo "✅ تم إضافة القماش بنجاح!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لوحة التحكم - إضافة موديلات</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f4f4f4; }
        .card { background: white; padding: 20px; margin-bottom: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        h2 { border-bottom: 2px solid #333; padding-bottom: 10px; }
        input, select, button { display: block; margin: 10px 0; padding: 10px; width: 100%; max-width: 400px; }
        button { background: #28a745; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>

    <div class="card">
        <h2>إضافة سرير جديد</h2>
        <form action="" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="type" value="bed">
            <input type="text" name="name" placeholder="اسم موديل السرير" required>
            <label>صورة الإطار (الظلال - PNG):</label>
            <input type="file" name="frame" accept="image/png" required>
            <label>صورة القناع (Mask - PNG):</label>
            <input type="file" name="mask" accept="image/png" required>
            <button type="submit">حفظ السرير</button>
        </form>
    </div>

    <div class="card">
        <h2>إضافة قماش جديد</h2>
        <form action="" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="type" value="fabric">
            <input type="text" name="name" placeholder="اسم القماش (مثلاً: مخمل أزرق)" required>
            <label>صورة القماش (Pattern):</label>
            <input type="file" name="texture" accept="image/jpeg,image/png" required>
            <button type="submit">حفظ القماش</button>
        </form>
    </div>

</body>
</html>