<?php
// FILE: fetch_product.php (API لجلب بيانات المنتج)
require_once __DIR__ . '/init.php'; 

header('Content-Type: application/json');

if (!isset($_SESSION['user'])) {
    echo json_encode(['success' => false, 'message' => 'غير مصرح لك.']);
    exit;
}

$barcode = trim($_POST['barcode'] ?? '');

if (empty($barcode)) {
    echo json_encode(['success' => false, 'message' => 'الرجاء إرسال رقم الباركود.']);
    exit;
}

try {
    // 🎯 تم تعديل أسماء الأعمدة في الاستعلام لـ name, size, production_date
    $stmt = $pdo->prepare("SELECT name, size, production_date 
                           FROM products 
                           WHERE barcode = ?"); 
    
    $stmt->execute([$barcode]);
    $product = $stmt->fetch();

    if ($product) {
        // 🎯 تم تعديل أسماء المفاتيح في مصفوفة JSON لتتوافق مع أسماء الأعمدة الجديدة
        echo json_encode([
            'success' => true,
            'product_name' => $product['name'],           // استخدام 'name'
            'size' => $product['size'],                   // استخدام 'size'
            'production_date' => $product['production_date'] // استخدام 'production_date'
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'لم يتم العثور على منتج بهذا الباركود.']);
    }

} catch (\PDOException $e) {
    // 💡 يمكن إظهار رسالة خطأ أكثر تفصيلاً للتصحيح إذا استمرت المشكلة
    echo json_encode(['success' => false, 'message' => 'خطأ في قاعدة البيانات. الرجاء مراجعة سجلات الخادم.']);
}
?>