<?php
// FILE: admin/qr_generator/generate.php - (تم إصلاح خطأ Uncaught Error: Class "Endroid\QrCode\QrCode" not found)

// 1. 🟢 إضافة تحميل مكتبات Composer (يجب أن يكون المسار صحيحاً)
// المسار: /barcode-system/vendor/autoload.php
require_once __DIR__ . '/../../vendor/autoload.php';

// 2. تضمين ملف إعدادات النظام الأساسي (للوصول إلى $pdo)
require_once __DIR__ . '/../../init.php';

// التأكد من أن المستخدم مسجل الدخول قبل توليد الرموز
if (!isset($_SESSION['user'])) {
    http_response_code(403);
    exit("Forbidden");
}

// استخدام مكتبة Endroid QrCode
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\ErrorCorrectionLevel; 
use Endroid\QrCode\Exception\FileNotFoundException; 

// **********************************************
// 1. استقبال البيانات وتصفيتها
// **********************************************
$url = filter_var($_GET['url'] ?? 'https://www.backcare.com.sa', FILTER_SANITIZE_URL);
$productName = $_GET['productName'] ?? 'QR Code Generated by BackCare';

// توليد قيمة الهاش (Checksum) بناءً على الـ URL
$checksum = md5($url);

try {
    // نستخدم متغير الاتصال $pdo المأخوذ من init.php
    
    // **********************************************
    // 2. التحقق من التخزين المؤقت (Check Cache)
    // **********************************************
    $stmt = $pdo->prepare("SELECT image_data FROM qr_codes WHERE checksum = ?");
    $stmt->execute([$checksum]);
    $cachedImage = $stmt->fetchColumn();

    if ($cachedImage) {
        // إذا وُجد في قاعدة البيانات، أرسله مباشرة
        header('Content-Type: image/png');
        echo $cachedImage;
        exit;
    }

    // **********************************************
    // 3. التوليد (Generate)
    // **********************************************
    
    // إعداد رمز QR
    $qrCode = QrCode::create($url)
        ->setEncoding(new Encoding('UTF-8'))
        ->setErrorCorrectionLevel(ErrorCorrectionLevel::High)
        // ***** حجم عالي لجودة الطباعة *****
        ->setSize(1000) 
        ->setMargin(10)
        ->setForegroundColor(new Color(50, 50, 50))
        ->setBackgroundColor(new Color(255, 255, 255));

    // إعداد الشعار (المسار الجديد بالنسبة للجذر)
    $logoFilePath = __DIR__ . '/../../assets/backcare-logo.png'; 
    $logo = null; 

    try {
        if (file_exists($logoFilePath)) {
            $logo = Logo::create($logoFilePath)
                ->setResizeToWidth(250) 
                ->setPunchoutBackground(true);
        } 
    } catch (FileNotFoundException $e) {
        // تجاهل
    } catch (\Throwable $e) {
        // تجاهل
    }

   // إعداد التسمية (المسار الجديد بالنسبة للجذر)
   $fontFilePath = __DIR__ . '/../../fonts/Arial.ttf';
   $label = Label::create($productName)
       ->setTextColor(new Color(0, 0, 0))
       // نستخدم الخط إذا كان موجودًا
       ->setFont(new \Endroid\QrCode\Label\Font\Font(file_exists($fontFilePath) ? $fontFilePath : 'Arial', 40)); 

    // توليد الصورة والحصول على البيانات الثنائية
    $writer = new PngWriter();
    $result = $writer->write($qrCode, $logo, $label);
    $imageData = $result->getString();

    // **********************************************
    // 4. التخزين في قاعدة البيانات (Store in Cache)
    // **********************************************
    $stmt = $pdo->prepare("INSERT INTO qr_codes (url_target, image_data, checksum) VALUES (?, ?, ?)");
    $stmt->bindValue(1, $url);
    $stmt->bindValue(2, $imageData, PDO::PARAM_LOB); // استخدام LOB للبيانات الثنائية
    $stmt->bindValue(3, $checksum);
    $stmt->execute();
    
    // **********************************************
    // 5. إرسال الصورة
    // **********************************************
    header('Content-Type: ' . $result->getMimeType());
    echo $imageData;

} catch (PDOException $e) {
    // في حالة فشل الاتصال بقاعدة البيانات
    header('Content-Type: text/plain');
    http_response_code(500);
    echo "Database Error: " . $e->getMessage();
    exit;
} catch (Exception $e) {
     // في حالة أي خطأ آخر (مثل عدم وجود GD)
    header('Content-Type: text/plain');
    http_response_code(500);
    echo "QR Generation Error: " . $e->getMessage();
    exit;
}
?>