<?php
// FILE: admin/qr_generator/index.php

// تضمين ملف الإعدادات الرئيسي للاتصال وقوائم الجلسة (Session)
require_once __DIR__ . '/../../init.php';

// التحقق من صلاحيات الدخول: مسموح لـ super_admin و admin
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'super_admin' && $_SESSION['user']['role'] !== 'admin')) {
    header('Location: /barcode-system/admin/login.php');
    exit;
}

// تحديد المسار النسبي لملف generate.php
$generate_api_path = './generate.php'; 
// تحديد المسار النسبي لشعار BackCare (للعرض في الصفحة)
$logo_path = '../../assets/backcare-logo.png'; 
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مولد QR Code الاحترافي | BackCare</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* تنسيقات CSS مخصصة */
        :root {
            /* تعريف اللون الأساسي لـ BackCare (الأزرق النيلي) */
            --backcare-primary: #0056b3; 
            --backcare-accent: #007bff; /* لون فرعي للأزرار/الإطارات */
        }
        body {
            background-color: #f8f9fa;
        }
        .qr-container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            margin-top: 50px;
        }
        .qr-output {
            min-height: 300px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #e9ecef;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        #qrImage {
            max-width: 100%;
            height: auto;
            border: 4px solid var(--backcare-accent); /* إطار حول الرمز */
            border-radius: 5px;
        }
        /* تعديل ألوان Bootstrap لتتوافق مع الهوية */
        .btn-primary {
            background-color: var(--backcare-primary);
            border-color: var(--backcare-primary);
        }
        .btn-primary:hover {
            background-color: #004085; /* لون أغمق عند التمرير */
            border-color: #004085;
        }
        .text-primary {
            color: var(--backcare-primary) !important;
        }
        .logo-img {
            max-width: 150px;
            height: auto;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 mt-3">
                <a href="/barcode-system/admin_dashboard.php" class="btn btn-secondary btn-sm">
                    <i class="bi bi-arrow-right-short me-2"></i> العودة للوحة التحكم
                </a>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="qr-container text-center">
                    
                    <img src="<?= $logo_path ?>" alt="شعار BackCare" class="logo-img">
                    
                    <h4 class="mb-4 text-primary">نظام توليد رمز QR لمنتجات شركة باك كير</h4>
                    <p class="text-muted">أدخل البيانات المطلوبة للحصول على الرمز</p>

                    <form id="qrForm">
                        <div class="mb-3">
                            <label for="urlInput" class="form-label float-end">رابط المنتج (URL)</label>
                            <input type="url" class="form-control" id="urlInput" placeholder="رابط المنتج (URL)" required>
                        </div>
                        <div class="mb-3">
                            <label for="productNameInput" class="form-label float-end">اسم المنتج</label>
                            <input type="text" class="form-control" id="productNameInput" name="productName" placeholder="اسم المنتج" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <span id="buttonText">إنشاء رمز QR</span>
                            <span id="loadingSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                        </button>
                    </form>

                    <hr class="my-4">

                    <div class="qr-output">
                        <p id="initialMessage" class="text-secondary m-0">سيظهر رمز QR هنا بعد الإنشاء</p>
                        <img id="qrImage" style="display: none;" alt="رمز QR">
                    </div>

                    <a id="downloadLink" class="btn btn-success w-100 mt-3 d-none" download="qrcode_backcare.png">
                        تحميل الرمز (جودة عالية)
                    </a>

                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // دالة تحويل البيانات
        document.getElementById('qrForm').onsubmit = function(event) {
            event.preventDefault();

            const url = document.getElementById('urlInput').value;
            const productName = document.getElementById('productNameInput').value;
            const qrImage = document.getElementById('qrImage');
            const downloadLink = document.getElementById('downloadLink');
            const initialMessage = document.getElementById('initialMessage');
            const loadingSpinner = document.getElementById('loadingSpinner');
            const buttonText = document.getElementById('buttonText');

            // 🟢 التحقق مرة أخرى من أن حقل التسمية ليس فارغاً (رغم وجود required في HTML)
            if (!productName.trim()) {
                alert("يجب إدخال اسم المنتج لتوليد رمز QR.");
                return;
            }

            // متغير مسار generate.php الذي تم تعريفه في PHP
            const GENERATE_API = '<?= $generate_api_path ?>';

            // 1. تفعيل وضع التحميل
            buttonText.textContent = 'جاري الإنشاء...';
            loadingSpinner.classList.remove('d-none');
            document.querySelector('button[type="submit"]').disabled = true;
            
            // إخفاء الرسائل القديمة وعناصر العرض
            qrImage.style.display = 'none';
            downloadLink.classList.add('d-none');
            initialMessage.style.display = 'none';

            // 2. بناء رابط API (generate.php)
            const apiUrl = GENERATE_API + '?url=' + encodeURIComponent(url) + '&productName=' + encodeURIComponent(productName);

            // 3. جلب الصورة من generate.php
            fetch(apiUrl)
                .then(response => {
                    if (!response.ok) {
                        // محاولة قراءة نص الخطأ إذا كان متوفراً
                        return response.text().then(text => {
                            throw new Error('فشل في إنشاء الرمز: ' + text.substring(0, 100)); // عرض جزء من رسالة الخطأ
                        });
                    }
                    return response.blob();
                })
                .then(imageBlob => {
                    const imageUrl = URL.createObjectURL(imageBlob);
                    
                    // عرض الصورة الجديدة
                    qrImage.src = imageUrl;
                    qrImage.style.display = 'block';
                    
                    // تجهيز رابط التنزيل
                    downloadLink.href = imageUrl;
                    downloadLink.setAttribute('download', 'qrcode_' + (productName || 'product') + '.png'); // تسمية الملف باسم المنتج
                    downloadLink.classList.remove('d-none');
                    
                    // استعادة النص الأولي لزر التحميل
                    buttonText.textContent = 'إنشاء رمز QR جديد';
                    
                })
                .catch(error => {
                    // عرض رسالة خطأ
                    initialMessage.textContent = 'حدث خطأ: ' + error.message;
                    initialMessage.style.display = 'block';
                    buttonText.textContent = 'حدث خطأ. حاول مجدداً.';
                    
                })
                .finally(() => {
                    // 4. تعطيل وضع التحميل
                    loadingSpinner.classList.add('d-none');
                    document.querySelector('button[type="submit"]').disabled = false;
                });
        };
    </script>
</body>
</html>