<?php
// FILE: init.php

// بدء الجلسات
session_start();

// ======= بيانات الاتصال بقاعدة البيانات (يجب تغييرها) =======
$host = 'localhost';
$db = 'bacsa23_barcode-system';
$user = 'bacsa23_barcode';
$pass = 'Uox+*qQ;QlZlbqF.';
$charset = 'utf8mb4';
// =======================================================

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    // تم تنظيف المسافات هنا
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

// تعريف إعدادات النظام ومصفوفة أدوار المستخدمين
$config = [
    // تم إزالة الشرطة المائلة الأمامية / هنا، كما طلبت
    'base_url' => 'barcode-system/', 
    'project_name' => 'نظام إدارة الباركود'
];

// تعريف أدوار المستخدمين
$config['user_roles'] = [
    'super_admin' => 'مدير عام',
    'admin' => 'مدير مقيد',
    'user' => 'مستخدم عادي',
    'delivery_agent' => 'مندوب تسليم'
];

// تعريف ثابت للمسار الجذر للمشروع (لزيادة الاستقرار)
if (!defined('ROOT_PATH')) {
    define('ROOT_PATH', __DIR__ . '/');
}


// ------------------------------------------------------------------
// 🆕 دالة مساعدة للتحقق من الصلاحيات (Access Control List - ACL)
// ------------------------------------------------------------------
/**
 * تتحقق مما إذا كان المستخدم الحالي لديه الصلاحية المطلوبة.
 *
 * @param string|array $required_permission الصلاحية المطلوبة (مثل 'products_add') أو مصفوفة صلاحيات.
 * @return bool
 */
function has_permission($required_permission) {
    // 1. التحقق من وجود الجلسة والدور
    if (!isset($_SESSION['user']['role'])) {
        return false;
    }

    $role = $_SESSION['user']['role'];

    // 2. السماح للمدير العام (Super Admin) بكل شيء
    if ($role === 'super_admin') {
        return true;
    }

    // 3. التحقق من الصلاحيات المخصصة للأدوار المقيدة
    if ($role === 'admin' || $role === 'delivery_agent') {
        // إذا لم يتم جلب مصفوفة الصلاحيات للجلسة، فافترض عدم وجود صلاحيات
        $user_permissions = $_SESSION['user']['permissions'] ?? [];

        // تحويل الصلاحية المطلوبة إلى مصفوفة لتوحيد المعالجة
        $permissions_to_check = is_array($required_permission) ? $required_permission : [$required_permission];

        // التحقق مما إذا كان المستخدم يمتلك *أي* من الصلاحيات المطلوبة
        foreach ($permissions_to_check as $perm) {
            if (in_array($perm, $user_permissions)) {
                return true;
            }
        }
        
        return false;
    }

    // 4. رفض الصلاحية لأي دور آخر (مثل 'user' أو 'guest' إذا وجد)
    return false;
}
// ------------------------------------------------------------------


// ------------------------------------------------------------------
// 🆕 دالة للحماية والتوجيه (Guard Function)
// ------------------------------------------------------------------
/**
 * تتحقق من صلاحيات المستخدم وتوجهه إلى صفحة أخرى إذا لم تتوفر الصلاحية.
 *
 * @param string|array $required_permission الصلاحية المطلوبة (مثل 'products_view').
 * @param string $redirect_page صفحة التوجيه عند الفشل (افتراضياً صفحة تسجيل الدخول).
 * @return void
 */
function require_permission($required_permission, $redirect_page = '/barcode-system/login.php') {
    // إذا لم يكن المستخدم مسجلاً دخوله على الإطلاق
    if (!isset($_SESSION['user'])) {
        header("Location: " . $redirect_page);
        exit;
    }

    // التحقق من الصلاحية باستخدام الدالة المساعدة
    if (!has_permission($required_permission)) {
        // توجيه المستخدم إلى لوحة التحكم الإدارية أو صفحة غير مصرح بها
        header("Location: /barcode-system/admin_dashboard.php?error=unauthorized");
        exit;
    }
}
// ------------------------------------------------------------------