<?php
// FILE: auth.php (معالج تسجيل الدخول والخروج)
require_once __DIR__ . '/init.php';

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $u = $_POST['username'] ?? '';
    $p = $_POST['password'] ?? '';

    // 🛑 التعديل الأول: سحب عمود permissions_json
    $stmt = $pdo->prepare('SELECT id, username, password_hash, role, permissions_json FROM users WHERE username = ? LIMIT 1');
    $stmt->execute([$u]);
    $user = $stmt->fetch();

    // التحقق من كلمة المرور
    if($user && password_verify($p, $user['password_hash'])){
        // تسجيل الدخول بنجاح

        // 🛑 التعديل الثاني: فك تشفير الصلاحيات وتخزينها في مصفوفة PHP
        $permissions_array = json_decode($user['permissions_json'] ?? '[]', true) ?: [];

        // إزالة كلمة المرور المشفرة والصلاحيات المشفرة قبل تخزين بيانات المستخدم
        unset($user['password_hash']);
        unset($user['permissions_json']);

        // تخزين بيانات المستخدم مع مصفوفة الصلاحيات المفكوكة
        $user['permissions'] = $permissions_array;
        $_SESSION['user'] = $user;


        // 🚀 منطق التوجيه بناءً على الدور
        if ($user['role'] === 'super_admin' || $user['role'] === 'admin') {
            // التوجيه إلى لوحة التحكم الإدارية
            header('Location: /barcode-system/admin_dashboard.php');
            exit;
        } elseif ($user['role'] === 'delivery_agent') {
            // التوجيه إلى لوحة تحكم مندوب التسليم
            header('Location: /barcode-system/delivery_dashboard.php');
            exit;
        }

        // في حال كان الدور غير مصرح به أو مفقود، نقوم بتسجيل الخروج وعرض رسالة خطأ
        session_destroy();
        $_SESSION['login_error'] = 'دور المستخدم غير صالح';
        header('Location: /barcode-system/admin/login.php');
        exit;
    }

    // فشل تسجيل الدخول: حفظ الخطأ وإعادة التوجيه لصفحة الدخول
    $_SESSION['login_error'] = 'بيانات الدخول غير صحيحة';
    header('Location: /barcode-system/admin/login.php');
    exit;
}

if(isset($_GET['action']) && $_GET['action']==='logout'){
    // تسجيل الخروج
    session_destroy();

    // التوجيه إلى صفحة تسجيل الدخول (باستخدام المسار المطلق)
    header('Location: /barcode-system/admin/login.php');
    exit;
}