<?php
require_once __DIR__ . '/../init.php';
$rows = $pdo->query("SELECT * FROM products ORDER BY created_at DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ar">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>واجهة المستخدم - Backcare</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body{font-family:Tajawal,sans-serif;background:#f7fbff;padding:16px;direction:rtl;}
.card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
#video{border-radius:8px;width:100%;max-width:320px;height:auto;margin-bottom:12px;display:none;}
</style>
</head>
<body>
<div class="card">
<h2>ماسح الباركود</h2>
<p>اضغط "ابدأ" ثم وجه الكاميرا إلى الباركود أو أدخله يدوياً.</p>
<input type="text" id="barcodeInput" class="form-control mb-2" placeholder="أدخل الباركود يدوياً">
<button class="btn btn-primary mb-2" id="scanBtn">مسح بالكميرا</button>
<a href="/barcode-system/admin/index.php" class="btn btn-secondary mb-2">الانتقال للوحة الإدارة</a>
<video id="video" autoplay></video>
<div id="productData"></div>
</div>

<script src="https://unpkg.com/@zxing/library@0.18.6/umd/index.min.js"></script>
<script>
const codeReader = new ZXing.BrowserBarcodeReader();
const video = document.getElementById('video');
const scanBtn = document.getElementById('scanBtn');
const barcodeInput = document.getElementById('barcodeInput');
const prodDiv = document.getElementById('productData');
let active=false;

function fetchProduct(barcode){
  fetch('/barcode-system/api/products.php', {
    method:'POST',
    headers:{'Content-Type':'application/json'},
    body: JSON.stringify({barcode: barcode})
  }).then(r=>r.json()).then(j=>{
    if(j.error){
      prodDiv.innerHTML = `<div class="card">لا يوجد منتج مرتبط بالباركود.</div>`;
    } else {
      let html='<div class="card">';
      html += `<div><strong>الاسم:</strong> ${j.name}</div>`;
      html += `<div><strong>الباركود:</strong> ${j.barcode}</div>`;
      html += `<div><strong>المقاس:</strong> ${j.size || '-'}</div>`;
      html += `<div><strong>تاريخ الإنتاج:</strong> ${j.production_date || '-'}</div>`;
      html += `<div><strong>تاريخ الانتهاء:</strong> ${j.expiry_date || '-'}</div>`;
      html += `<div><strong>ملاحظات:</strong> ${j.notes || '-'}</div>`;
      html+='</div>';
      prodDiv.innerHTML = html;
    }
  }).catch(e=>{
    prodDiv.innerHTML=`<div class="card">حدث خطأ أثناء جلب البيانات</div>`;
  });
}

// المسح بالكاميرا
scanBtn.addEventListener('click', ()=>{
  if(active){
    codeReader.reset();
    video.style.display='none';
    scanBtn.textContent='مسح بالكميرا';
    active=false;
    return;
  }
  video.style.display='block';
  scanBtn.textContent='إيقاف الكاميرا';
  active=true;
  codeReader.decodeFromVideoDevice(undefined, video, (result, err)=>{
    if(result){
      barcodeInput.value = result.text.trim();
      fetchProduct(result.text.trim());
      codeReader.reset();
      video.style.display='none';
      scanBtn.textContent='مسح بالكميرا';
      active=false;
    }
  }).catch(err=>{
    alert('فشل الوصول للكاميرا: '+err);
    video.style.display='none';
    scanBtn.textContent='مسح بالكميرا';
    active=false;
  });
});

// البحث عند إدخال الرمز يدوياً
barcodeInput.addEventListener('change', ()=>{
  fetchProduct(barcodeInput.value.trim());
});
</script>
</body>
</html>
