<?php
require_once __DIR__ . '/../init.php';
if(!isset($_SESSION['user'])){ header('Location: /barcode-system/login.php'); exit; }

$rows = $pdo->query("SELECT * FROM products ORDER BY created_at DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC);

// التعامل مع إضافة المنتج عبر POST
$error = $success = '';
if($_SERVER['REQUEST_METHOD']==='POST'){
    $barcode = trim($_POST['barcode'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $size = trim($_POST['size'] ?? '');
    $production_date = $_POST['production_date'] ?: null;
    $expiry_date = $_POST['expiry_date'] ?: null;
    $notes = trim($_POST['notes'] ?? '');

    if(!$barcode || !$name){
        $error="الباركود واسم المنتج مطلوبان.";
    } else {
        // التأكد من عدم وجود الباركود مسبقاً
        $check = $pdo->prepare("SELECT id FROM products WHERE barcode=?");
        $check->execute([$barcode]);
        if($check->fetch()){
            $error="رمز الباركود مسجل مسبقاً.";
        } else {
            $stmt = $pdo->prepare("INSERT INTO products (barcode, name, size, production_date, expiry_date, notes, created_by) VALUES (?,?,?,?,?,?,?)");
            $stmt->execute([$barcode, $name, $size ?: null, $production_date, $expiry_date, $notes, $_SESSION['user']['id']]);
            $success="تمت إضافة المنتج بنجاح.";
            // إعادة جلب المنتجات لتحديث الجدول بعد الإضافة
            $rows = $pdo->query("SELECT * FROM products ORDER BY created_at DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC);
        }
    }
}
?>
<!doctype html>
<html lang="ar">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>لوحة الإدارة - Backcare</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body{font-family:Tajawal,sans-serif;background:#f6f8fa;padding:16px;direction:rtl;}
.card{border-radius:12px;padding:16px;margin-bottom:16px;box-shadow:0 4px 12px rgba(0,0,0,0.05);}
#video{border-radius:8px;width:100%;max-width:320px;height:auto;margin-bottom:12px;display:none;}
</style>
</head>
<body>

<div class="card">
<h2>إضافة منتج جديد</h2>

<?php if($error) echo "<p class='text-danger'>$error</p>"; ?>
<?php if($success) echo "<p class='text-success'>$success</p>"; ?>

<form id="addForm" method="post">
  <div class="mb-2"><label>الباركود:</label>
  <div class="input-group">
    <input type="text" class="form-control" name="barcode" id="barcodeInput" required>
    <button type="button" class="btn btn-outline-primary" id="scanBtn">مسح بالكميرا</button>
  </div></div>

  <div class="mb-2"><label>اسم المنتج:</label>
    <input type="text" class="form-control" name="name" required>
  </div>
  <div class="mb-2"><label>المقاس:</label>
    <input type="text" class="form-control" name="size" placeholder="مثلاً: صغير / وسط / كبير">
  </div>
  <div class="mb-2"><label>تاريخ الإنتاج:</label>
    <input type="date" class="form-control" name="production_date">
  </div>
  <div class="mb-2"><label>تاريخ الانتهاء:</label>
    <input type="date" class="form-control" name="expiry_date">
  </div>
  <div class="mb-2"><label>ملاحظات:</label>
    <textarea class="form-control" name="notes" rows="2"></textarea>
  </div>
  <button type="submit" class="btn btn-primary mt-2">حفظ المنتج</button>
  <a href="/barcode-system/user/index.php" class="btn btn-secondary mt-2">الانتقال لواجهة المستخدم</a>
</form>
<video id="video" autoplay></video>
</div>

<div class="card">
<h2>المنتجات المسجلة</h2>
<table class="table table-striped">
<thead class="table-primary">
<tr>
<th>الباركود</th><th>الاسم</th><th>المقاس</th><th>تاريخ الإنتاج</th><th>تاريخ الانتهاء</th><th>ملاحظات</th>
</tr>
</thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr>
<td><?=htmlspecialchars($r['barcode'])?></td>
<td><?=htmlspecialchars($r['name'])?></td>
<td><?=htmlspecialchars($r['size'] ?? '-')?></td>
<td><?=htmlspecialchars($r['production_date'] ?? '-')?></td>
<td><?=htmlspecialchars($r['expiry_date'] ?? '-')?></td>
<td><?=htmlspecialchars($r['notes'] ?? '-')?></td>
</tr>
<?php endforeach;?>
</tbody>
</table>
</div>

<script src="https://unpkg.com/@zxing/library@0.18.6/umd/index.min.js"></script>
<script>
const codeReader = new ZXing.BrowserBarcodeReader();
const video = document.getElementById('video');
const scanBtn = document.getElementById('scanBtn');
const barcodeInput = document.getElementById('barcodeInput');
let active=false;

scanBtn.addEventListener('click', ()=>{
  if(active){
    codeReader.reset();
    video.style.display='none';
    scanBtn.textContent='مسح بالكميرا';
    active=false;
    return;
  }
  video.style.display='block';
  scanBtn.textContent='إيقاف الكاميرا';
  active=true;

  codeReader.decodeFromVideoDevice(undefined, video, (result, err)=>{
    if(result){
      barcodeInput.value = result.text.trim();
      codeReader.reset();
      video.style.display='none';
      scanBtn.textContent='مسح بالكميرا';
      active=false;
    }
  }).catch(err=>{
    alert('فشل الوصول للكاميرا: '+err);
    video.style.display='none';
    scanBtn.textContent='مسح بالكميرا';
    active=false;
  });
});
</script>
</body>
</html>
