

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h3 class="fw-bold mb-4" style="color: #ffffff;">لوحة الإحصائيات الذكية</h3>
    
    <div class="row g-4 mb-5">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-secondary fw-bold mb-1">إجمالي الأسئلة</h6>
                        <h2 class="fw-bold mb-0" style="color: var(--primary-color);"><?php echo e($questionsCount); ?></h2>
                    </div>
                    <div class="rounded-circle p-3" style="background: var(--primary-color); color: white;">
                        <i class="fas fa-question-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-secondary fw-bold mb-1">طلبات الاستشارة (واتساب)</h6>
                        <h2 class="fw-bold mb-0 text-success"><?php echo e($leadsCount); ?></h2>
                    </div>
                    <div class="rounded-circle p-3 bg-success text-white">
                        <i class="fab fa-whatsapp fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-md-12">
            <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
                <h5 class="fw-bold mb-4" style="color: #2d3436;">
                    <i class="fas fa-chart-area me-2" style="color: var(--primary-color);"></i>تحليل نمو طلبات الاستشارة (آخر 7 أيام)
                </h5>
                <canvas id="leadsChart" height="100"></canvas>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
        <h5 class="fw-bold mb-3" style="color: #2d3436;">أحدث طلبات الاستشارة</h5>
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="bg-light">
                    <tr>
                        <th style="color: #636e72;">رقم الجوال</th>
                        <th style="color: #636e72;">تاريخ الطلب</th>
                        <th style="color: #636e72;">نص الاستشارة</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $latestLeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="fw-bold text-success"><?php echo e($lead->phone); ?></td>
                        <td class="text-dark"><?php echo e($lead->created_at->format('Y-m-d H:i')); ?></td>
                        <td class="text-secondary"><?php echo e(Str::limit($lead->consultation_text, 50)); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="3" class="text-center p-4 text-muted">لا توجد بيانات حالياً</td></tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('leadsChart').getContext('2d');
    const leadsChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($chartLabels); ?>,
            datasets: [{
                label: 'عدد الطلبات',
                data: <?php echo json_encode($chartValues); ?>,
                borderColor: '<?php echo e($settings->primary_color ?? "#28a745"); ?>',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: '<?php echo e($settings->primary_color ?? "#28a745"); ?>',
                pointRadius: 4
            }]
        },
        options: {
            responsive: true,
            plugins: { 
                legend: { display: false },
                tooltip: {
                    titleFont: { family: 'AppCustomFont' },
                    bodyFont: { family: 'AppCustomFont' }
                }
            },
            scales: {
                y: { 
                    beginAtZero: true, 
                    ticks: { stepSize: 1, color: '#636e72' },
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: { 
                    ticks: { color: '#636e72' },
                    grid: { display: false } 
                }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/bacsa23/public_html/bank-project/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>