<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - لوحة التحكم</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, sans-serif;
        }
        .login-card {
            background: white;
            padding: 40px;
            border-radius: 30px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
            border-top: 8px solid #007bff;
        }
        .login-logo {
            width: 150px;
            margin-bottom: 25px;
        }
        .form-control {
            border-radius: 12px;
            padding: 12px;
            border: 1px solid #e2e8f0;
        }
        .btn-login {
            background: #007bff;
            border: none;
            border-radius: 12px;
            padding: 12px;
            font-weight: bold;
            transition: 0.3s;
        }
        .btn-login:hover {
            background: #0056b3;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>

<div class="login-card text-center">
    <img src="<?php echo e(asset('assets/images/backcare_logo.png')); ?>" class="login-logo" alt="Logo">
    <h4 class="fw-bold mb-4 text-dark">دخول الإدارة</h4>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
        <div class="alert alert-danger small border-0 mb-4">
            <i class="fas fa-exclamation-circle ms-1"></i> <?php echo e($errors->first()); ?>

        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <form action="<?php echo e(route('login.post')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="mb-3 text-end">
            <label class="form-label small fw-bold">البريد الإلكتروني</label>
            <div class="input-group">
                <span class="input-group-text bg-light border-0"><i class="fas fa-envelope text-muted"></i></span>
                <input type="email" name="email" class="form-control" placeholder="name@example.com" required autofocus>
            </div>
        </div>

        <div class="mb-4 text-end">
            <label class="form-label small fw-bold">كلمة المرور</label>
            <div class="input-group">
                <span class="input-group-text bg-light border-0"><i class="fas fa-lock text-muted"></i></span>
                <input type="password" name="password" class="form-control" placeholder="••••••••" required>
            </div>
        </div>

        <button type="submit" class="btn btn-primary btn-login w-100 mb-3">
            دخول <i class="fas fa-sign-in-alt me-2"></i>
        </button>
        
        <a href="/" class="text-muted small text-decoration-none">العودة للموقع الرئيسي</a>
    </form>
</div>

</body>
</html><?php /**PATH /home/bacsa23/public_html/bank-project/resources/views/auth/login.blade.php ENDPATH**/ ?>