<?php
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\QuestionController; // متحكم الواجهة الأمامية
use App\Http\Controllers\Admin\QuestionController as AdminQuestionController; // متحكم الإدارة
use App\Http\Controllers\Admin\UserController;

/*
|--------------------------------------------------------------------------
| الواجهة الأمامية (User Interface)
|--------------------------------------------------------------------------
*/
Route::get('/', [QuestionController::class, 'index'])->name('home');
Route::get('/get-answer/{id}', [QuestionController::class, 'getAnswer']);

// رابط إرسال الواتساب من الواجهة الأمامية
Route::post('/send-whatsapp', [QuestionController::class, 'sendWhatsapp']);

/*
|--------------------------------------------------------------------------
| نظام الدخول (Authentication)
|--------------------------------------------------------------------------
*/
Route::get('/manager/login', function () {
    if (Auth::check()) return redirect()->route('admin.dashboard');
    return view('auth.login'); 
})->name('login');

// إصلاح خطأ loginPost عبر ربطه بالدالة المضافة في المتحكم
Route::post('/manager/login', [AdminQuestionController::class, 'loginPost'])->name('login.post');

Route::post('/manager/logout', function (Request $request) {
    Auth::logout();
    $request->session()->invalidate();
    $request->session()->regenerateToken();
    return redirect()->route('login');
})->name('admin.logout');

/*
|--------------------------------------------------------------------------
| لوحة التحكم (Admin Panel)
|--------------------------------------------------------------------------
*/
Route::prefix('manager')->name('admin.')->middleware('auth')->group(function () {
    
    // الرئيسية - إصلاح خطأ المتغيرات المفقودة
    Route::get('/dashboard', [AdminQuestionController::class, 'dashboard'])->name('dashboard');
    
    // إدارة الأسئلة - إصلاح خطأ Call to undefined method create()
    Route::resource('questions', AdminQuestionController::class);
    
    // إعدادات النظام وفيديو الإنترو - تم توحيدها في QuestionController لضمان عملها
    Route::get('/settings', [AdminQuestionController::class, 'editSettings'])->name('settings.index');
    Route::post('/settings/update', [AdminQuestionController::class, 'updateSettings'])->name('settings.update');

    // الملف الشخصي والأمان
    Route::get('/profile', [AdminQuestionController::class, 'editProfile'])->name('profile');
    Route::post('/profile/update', [AdminQuestionController::class, 'updateProfile'])->name('profile.update');

    // إدارة المستخدمين
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users/store', [UserController::class, 'store'])->name('users.store');
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');
});