<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}"> 
    <title>Dr. Back Care - الاستشارة الذكية</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <style>
        :root { 
            --primary: {{ $settings->primary_color ?? '#007bff' }}; 
            --success: #28a745; 
            --light-blue: {{ $settings->bg_color ?? '#f0f7ff' }};
            --font-main: {{ $settings->font_family ?? "'Segoe UI', Tahoma, sans-serif" }};
            --doc-width: {{ $settings->doctor_mini_size ?? '110' }}px;

            /* تحكم في المقاسات المطلوبة للّابتوب */
            --desktop-max-h: 80vh;
            --media-gap: 2%;
        }

        html, body { 
            overflow-x: hidden; 
            width: 100%;
            margin: 0;
            padding: 0;
            touch-action: pan-y;
        }

        body { 
            @if(isset($settings) && $settings->bg_type == 'gradient')
                background: linear-gradient(135deg, {{ $settings->bg_color }}, {{ $settings->bg_gradient_end }}) fixed !important;
            @elseif(isset($settings) && $settings->bg_type == 'image' && $settings->bg_image)
                background-image: url("{{ asset('storage/' . $settings->bg_image) }}") !important;
                background-size: cover;
            @else
                background-color: {{ $settings->bg_color ?? '#f4f7f6' }} !important;
            @endif

            @if(isset($settings) && $settings->custom_font)
                font-family: 'AppCustomFont', sans-serif !important;
            @endif
        }
        
        @font-face {
            font-family: 'AppCustomFont';
            src: url("{{ asset('assets/fonts/' . ($settings->custom_font ?? '')) }}") format('truetype');
        }

        .btn-primary, .mascot-btn { background-color: var(--primary) !important; }
        .text-primary { color: var(--primary) !important; }

        #start-screen { position: fixed; inset: 0; z-index: 9999; background: white; display: flex; flex-direction: column; justify-content: center; align-items: center; }
        .logo-main { width: 200px; margin-bottom: 30px; }

        .mascot-btn { 
            width: 180px; height: 180px; background: var(--primary); border-radius: 50%; 
            border: 6px solid white; box-shadow: 0 10px 30px rgba(0,0,0,0.1); 
            cursor: pointer; display: flex; justify-content: center; align-items: center;
            animation: pulse-shadow 2s infinite;
        }
        .mascot-btn img { width: 80%; animation: head-bob 2.5s ease-in-out infinite; }
        @keyframes head-bob { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-12px); } }
        @keyframes pulse-shadow { 0% { box-shadow: 0 0 0 0 rgba(0, 123, 255, 0.5); } 70% { box-shadow: 0 0 0 20px rgba(0, 123, 255, 0); } 100% { box-shadow: 0 0 0 0 rgba(0, 123, 255, 0); } }

        .qs-container { background: #ffffff; border-radius: 20px; padding: 10px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); }
        .btn-question {
            width: 100%; text-align: right; padding: 15px 20px; border-radius: 12px;
            border: 1px solid #f0f0f0; background: #fff; margin-bottom: 12px;
            font-weight: 500; font-size: 0.95rem; color: #3c81ff;
            display: flex; justify-content: space-between; align-items: center;
            transition: all 0.3s ease; border-right: 4px solid transparent;
        }
        .btn-question:hover { background: var(--light-blue); color: var(--primary); border-right: 4px solid var(--primary); transform: translateX(-5px); }

        /* ======== زر العودة (ديسكتوب) ======== */
        .back-nav-bar {
            width: 100%;
            padding: 15px;
            background: #fff;
            color: #6b6b6b; 
            text-align: center;
            font-weight: 700;
            border-radius: 15px; 
            border: 2px solid var(--primary);
            cursor: pointer;
            transition: all 0.25s ease;
            margin-top: 14px;
            box-shadow: 0 4px 12px rgba(0,123,255,0.12);
        }
        .back-nav-bar:hover { background: var(--primary); color: #fff; transform: translateY(-2px); }

        /* إخفاء زر العودة على الديسكتوب إلا عند فتح الإجابة */
        #back-btn-desk { display: none; }
        body.active #back-btn-desk { display: block; }

        /* =========================
           اللابتوب: تعديل المقاسات
           ========================= */
        @media (min-width: 992px) {
            .app-layout {
                display: none;
                width: 100vw;
                height: 100vh;
                overflow: hidden;
            }

            /* حاوية قائمة الأسئلة */
            #questions-section {
                position: fixed;
                top: 48%;
                left: 50%;
                transform: translate(-50%, -50%);
                width: 40%;
                transition: all 0.7s ease;
                z-index: 3000;
                max-height: var(--desktop-max-h);
            }

            /* عند تفعيل الإجابة */
            body.active #questions-section {
                left: auto;
                right: 0;
                top: 48%;
                transform: translateY(-50%);
                width: 30%;
                padding: 25px;
                max-height: var(--desktop-max-h);
            }

            /* حاوية الإجابة */
            #answer-section { 
                position: fixed;
                left: 47.5%;
                top: 50%;
                transform: translate(-50%, -50%); 
                width: 40%;
                max-height: var(--desktop-max-h);
                opacity: 0;
                visibility: hidden;
                transition: 0.5s; 
                background: #fff;
                border-radius: 25px;
                border-top: 10px solid var(--primary); 
                box-shadow: 0 25px 60px rgba(0,0,0,0.1);
                z-index: 2500; 
                display: flex;
                flex-direction: column;
                overflow: hidden;
            }
            body.active #answer-section {
                opacity: 1;
                visibility: visible;
                display: flex !important;
            }

            /* عمود الوسائط: إجمالي ارتفاع 80% وتوزيع متساوي */
            .left-media-column {
                position: fixed;
                left: 0;
                top: 50%;
                transform: translateY(-50%);
                width: 25%;
                height: var(--desktop-max-h);
                padding: 20px;
                display: flex;
                flex-direction: column;
                gap: var(--media-gap);
                opacity: 0;
                transition: 0.6s;
                z-index: 2000;
                box-sizing: border-box;
            }
            body.active .left-media-column { opacity: 1; }

            .media-card{
                flex: 1 1 0;
                min-height: 0;
            }

            .qs-container{
                max-height: var(--desktop-max-h);
                overflow: hidden;
                display: flex;
                flex-direction: column;
            }
            .qs-container .qs-scroll{
                overflow-y: auto;
                overflow-x: hidden;
                max-height: calc(var(--desktop-max-h) - 70px);
                padding-left: 4px;
            }
        }

        /* ======== هيدر الإجابة (شكل احترافي) ======== */
        .answer-header{
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px 22px;
            background: linear-gradient(135deg, var(--primary), #4da3ff);
            color: #fff;
            box-shadow: 0 6px 18px rgba(0,0,0,0.12);
        }
        .answer-header-left{
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .answer-emoji{
            font-size: 24px;
            line-height: 1;
        }
        .answer-title{
            font-size: 1.05rem;
            font-weight: 800;
            letter-spacing: 0.2px;
        }
        .answer-badge{
            background: rgba(255,255,255,0.20);
            padding: 6px 14px;
            border-radius: 30px;
            font-size: 0.78rem;
            font-weight: 700;
        }

        /* النص داخل الإجابة */
        #answer-text { 
            flex: 1 1 auto;
            overflow-y: auto; 
            overflow-x: hidden;
            font-size: 1.2rem;
            line-height: 1.9;
            padding: 20px;
            scrollbar-width: thin;
            scrollbar-color: var(--primary) #f1f1f1;
            min-height: 0;
        }
        #answer-text::-webkit-scrollbar { width: 6px; }
        #answer-text::-webkit-scrollbar-track { background: #f1f1f1; border-radius: 10px; }
        #answer-text::-webkit-scrollbar-thumb { background: var(--primary); border-radius: 10px; }

        /* ======== شريط التحكم (شكل احترافي) ======== */
        .answer-controls{
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 14px 20px;
            background: #f9fbff;
            border-top: 1px solid #e6efff;
        }
        .controls-left{ display:flex; gap:12px; }

        .control-btn{
            width: 44px;
            height: 44px;
            border-radius: 50%;
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            cursor: pointer;
            transition: all 0.25s ease;
            box-shadow: 0 6px 14px rgba(0,0,0,0.12);
        }
        .control-btn:hover{
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.18);
        }
        .control-btn.audio{ background:#e3f2fd; color:#007bff; }
        .control-btn.video{ background:#fff3e0; color:#ff9800; }
        .control-btn.whatsapp{ background:#e8f5e9; color:#25d366; font-size:1.25rem; }

        /* إخفاء أزرار الصوت/الفيديو افتراضيًا حتى يأتي الداتا */
        #audio-btn, #vid-ctrl-btn { display:none; }

        /* =========================
           الجوال: تنظيم الوسائط فقط
           ========================= */
        @media (max-width: 991px) {
            .app-layout { 
                display: none; 
                padding: 10px;
                width: 100%;
                overflow-x: hidden;
            }

            body.active #questions-section { display: none; }

            body.active #answer-section { 
                display: block !important; 
                position: relative;
                width: 100%; 
                left: 0; 
                top: 0; 
                transform: none; 
                margin-top: 20px;
                margin-bottom: 18px; /* ✅ تقليل المارجن لأن الوسائط تأتي بعدها */
                border-radius: 25px; 
                border-top: 8px solid var(--primary); 
                background: linear-gradient(to bottom, #ffffff, #f8fbff); 
                box-shadow: 0 10px 30px rgba(0,0,0,0.08);
                height: auto; 
                max-height: none; 
                overflow-x: hidden;
            }

            #answer-text { 
                max-height: none !important; 
                overflow-y: visible !important;
                overflow-x: hidden !important;
                padding: 25px 20px;
                font-size: 1.15rem;
                color: #333;
                width: 100%;
                box-sizing: border-box;
            }

            /* ✅ ترتيب حاويات الوسائط تحت الإجابة بشكل مستطيل + فجوة */
            .left-media-column{
                position: relative;
                width: 100%;
                padding: 0;
                margin-top: 12px;
                display: flex;
                flex-direction: column;
                gap: 12px; /* ✅ الفجوة بين الفيديو والصورة */
            }

            /* ✅ جعل فيديو الشرح وصورة المنتج مستطيلين */
            #prod-vid-card,
            #prod-img-card{
                display: none; /* يبقى الإظهار من الجافاسكربت */
                width: 100%;
                aspect-ratio: 16 / 9;  /* ✅ شكل مستطيل احترافي */
                max-height: 220px;     /* ✅ تقليل الارتفاع */
                border-radius: 16px;
                overflow: hidden;
                background: #fff;
                box-shadow: 0 8px 22px rgba(0,0,0,0.08);
                border: 1px solid #eef2ff;
            }

            /* إبقاء فيديو الدكتور المصغر كدائرة fixed */
            #doc-mini-card { 
                position: fixed; 
                bottom: 85px; 
                left: 20px; 
                width: var(--doc-width); 
                height: var(--doc-width); 
                z-index: 9000; 
                border-radius: 50%; 
                border: 3px solid #fff; 
                box-shadow: 0 5px 20px rgba(0,0,0,0.2); 
                display: none; 
                overflow: hidden;
                background:#fff;
            }

            #back-btn-mob { 
                display: block !important;
                position: fixed;
                bottom: 15px;
                left: 5%;
                width: 90%;
                z-index: 9500;
                background: var(--primary) !important;
                color: #fff !important;
                border: none;
                border-radius: 50px;
                box-shadow: 0 8px 20px rgba(0,0,0,0.2);
            }
        }

        .media-card { 
            width: 100%; 
            background: #fff; 
            border-radius: 20px; 
            overflow: hidden; 
            box-shadow: 0 5px 15px rgba(0,0,0,0.05); 
            border: 1px solid #eee; 
            display: none; 
        }

        .media-card video,
        .media-card img{
            width: 100%;
            height: 100%;
            object-fit: contain;
            display: block;
        }

        /* مودال واتساب */
        #wa-modal{
            position:fixed; inset:0;
            display:none;
            align-items:center; justify-content:center;
            background:rgba(0,0,0,0.35);
            z-index:99999;
            padding: 15px;
        }
        .wa-content{
            background:#fff;
            width:min(420px, 100%);
            border-radius:18px;
            padding:20px;
            text-align:center;
        }
    </style>
</head>

<body>

<div id="start-screen">
    <img src="{{ asset('assets/images/backcare_logo.png') }}" class="logo-main" alt="Logo">
    <div class="mascot-btn" onclick="startFlow()">
        <img src="{{ asset('assets/images/dr-mascot-head.png') }}" alt="Mascot">
    </div>
    <h5 class="mt-4 text-primary fw-bold">استشـر دكتـور باك كيـر</h5>
</div>

<div id="intro-wrapper" style="position:fixed; inset:0; z-index:8888; display:none; background: {{ $settings->intro_bg_color ?? '#ffffff' }};">
    <video id="intro-video" style="width:100%; height:100%; object-fit:contain;" playsinline>
        <source src="{{ $settings->intro_video_path ? asset('storage/' . $settings->intro_video_path) : asset('assets/video/dr-back-care-intro.mp4') }}" type="video/mp4">
    </video>
    <button class="btn btn-dark rounded-pill px-4 position-fixed shadow" 
            style="bottom:30px; left:50%; transform:translateX(-50%); z-index: 8889;" 
            onclick="skipIntro()">تخطي</button>
</div>

<div id="app-content" class="app-layout">
    <div id="questions-section">
        <div class="qs-container">
            <h5 class="text-center mb-4 text-primary fw-bold">قائمة الاستفسارات</h5>

            <div class="qs-scroll">
                @foreach($questions as $question)
                <button class="btn-question shadow-sm" onclick="askDr({{ $question->id }})">
                    <span>{{ $question->title }}</span><i class="fas fa-chevron-left opacity-50 small"></i>
                </button>
                @endforeach
            </div>
        </div>
    </div>

    <div id="answer-section">
        <div class="answer-header">
            <div class="answer-header-left">
                <span class="answer-emoji">👨‍⚕️</span>
                <span class="answer-title">رد دكتور باك كير</span>
            </div>
            <span class="answer-badge">استشارة طبية</span>
        </div>

        <div id="answer-text"></div>
        
        <div class="answer-controls">
            <div class="controls-left">
                <button id="audio-btn" class="control-btn audio" onclick="togglePlayer()">
                    <i id="audio-icon" class="fas fa-volume-up"></i>
                </button>

                <button id="vid-ctrl-btn" class="control-btn video" onclick="toggleProdVid()">
                    <i id="vid-icon" class="fas fa-pause"></i>
                </button>
            </div>

            <button class="control-btn whatsapp" onclick="openWA()">
                <i class="fab fa-whatsapp"></i>
            </button>
        </div>

        <div id="back-btn-desk" class="back-nav-bar d-none d-lg-block" onclick="resetFlow()">
            <i class="fas fa-undo-alt me-2"></i> العودة لقائمة الاستفسارات
        </div>
    </div>

    <!-- ✅ على الجوال سيتم ترتيب هذه الحاويات تحت الإجابة -->
    <div class="left-media-column">
        <div id="doc-mini-card" class="media-card">
            <video id="doc-video" playsinline muted loop>
                <source id="doc-source" src="" type="video/mp4">
            </video>
        </div>

        <div id="prod-vid-card" class="media-card">
            <video id="prod-video" muted loop playsinline>
                <source id="prod-source" src="" type="video/mp4">
            </video>
        </div>

        <div id="prod-img-card" class="media-card">
            <img id="prod-img" alt="Product">
        </div>

        <div id="back-btn-mob" class="back-nav-bar d-lg-none" onclick="resetFlow()">
            <i class="fas fa-chevron-up me-2"></i> العودة لقائمة الاستفسارات
        </div>
    </div>
</div>

<div id="wa-modal">
    <div class="wa-content shadow-lg">
        <i class="fab fa-whatsapp fa-3x text-success mb-3"></i>
        <h6 class="fw-bold mb-3">سيصلك ملخص الاستشارة عبر الواتساب</h6>
        <input type="tel" id="user-phone" class="form-control text-center mb-3 rounded-pill" placeholder="05xxxxxxxx">
        <button class="btn btn-success w-100 rounded-pill fw-bold py-2" id="send-wa-btn" onclick="sendWA()">إرسال الآن</button>
        <button class="btn btn-link text-muted mt-2 text-decoration-none" onclick="closeWA()">إغلاق</button>
        <div id="wa-done" class="mt-3 text-success fw-bold" style="display:none;">تم الإرسال بنجاح! ✓</div>
    </div>
</div>

<audio id="audio-player" class="d-none"></audio>

<script>
    const introV    = document.getElementById('intro-video');
    const docV      = document.getElementById('doc-video');
    const prodV     = document.getElementById('prod-video');
    const player    = document.getElementById('audio-player');
    const answerSec = document.getElementById('answer-section');

    const audioBtn  = document.getElementById('audio-btn');
    const vidBtn    = document.getElementById('vid-ctrl-btn');
    const audioIcon = document.getElementById('audio-icon');
    const vidIcon   = document.getElementById('vid-icon');

    let currentQuestionTitle = "";
    let currentAnswerContent = "";

    function startFlow() {
        document.getElementById('start-screen').style.display = 'none';
        document.getElementById('intro-wrapper').style.display = 'flex';
        introV.play();
        introV.onended = showApp;
    }

    function skipIntro() {
        introV.pause();
        showApp();
    }

    function showApp() {
        document.getElementById('intro-wrapper').style.display = 'none';
        document.getElementById('app-content').style.display = (window.innerWidth >= 992) ? 'flex' : 'block';
    }

    function askDr(id) {
        document.body.classList.add('active');
        answerSec.style.display = 'flex';
        answerSec.style.visibility = 'visible';
        answerSec.style.opacity = '1';

        // إخفاء وسائط قديمة
        document.querySelectorAll('.media-card').forEach(card => card.style.display = 'none');

        // إخفاء أزرار الصوت/الفيديو لحين وصول الداتا
        audioBtn.style.display = 'none';
        vidBtn.style.display = 'none';

        // إيقاف كل شيء
        try { player.pause(); } catch(e){}
        try { docV.pause(); } catch(e){}
        try { prodV.pause(); } catch(e){}

        fetch(`{{ url('get-answer') }}/${id}`)
            .then(res => res.json())
            .then(data => {
                if(!data.status) return;

                currentQuestionTitle = data.title;
                currentAnswerContent = data.answer;

                document.getElementById('answer-text').innerHTML = data.answer;
                document.getElementById('answer-text').scrollTop = 0;

                // فيديو الدكتور المصغر (صامت) - يعمل/يتوقف مع الصوت
                if (data.doctor_video) {
                    document.getElementById('doc-source').src = data.doctor_video;
                    docV.load();
                    docV.play().catch(()=>{});
                    document.getElementById('doc-mini-card').style.display = 'block';
                }

                // الصوت يبدأ تلقائياً + فيديو الدكتور معه
                if (data.audio) {
                    player.src = data.audio;
                    audioBtn.style.display = 'inline-flex';

                    player.play().then(()=>{
                        if (data.doctor_video) docV.play().catch(()=>{});
                        setAudioIconState(false);
                    }).catch(()=>{
                        setAudioIconState(true);
                    });
                } else {
                    setAudioIconState(true);
                }

                // فيديو الشرح (صامت) مستقل
                if (data.video) {
                    document.getElementById('prod-source').src = data.video;
                    prodV.muted = true;
                    prodV.load();
                    prodV.play().catch(()=>{});
                    document.getElementById('prod-vid-card').style.display = 'block';

                    vidBtn.style.display = 'inline-flex';
                    setVidIconState(false);
                } else {
                    setVidIconState(true);
                }

                // صورة المنتج
                if (data.image) {
                    document.getElementById('prod-img').src = data.image;
                    document.getElementById('prod-img-card').style.display = 'block';
                }
            });
    }

    function setAudioIconState(isPaused){
        audioIcon.classList.remove('fa-volume-up', 'fa-volume-mute');
        audioIcon.classList.add(isPaused ? 'fa-volume-mute' : 'fa-volume-up');
    }

    function setVidIconState(isPaused){
        vidIcon.classList.remove('fa-play', 'fa-pause');
        vidIcon.classList.add(isPaused ? 'fa-play' : 'fa-pause');
    }

    // الصوت + فيديو الدكتور معاً
    function togglePlayer() {
        if (player.paused) {
            player.play().then(()=>{
                docV.play().catch(()=>{});
                setAudioIconState(false);
            }).catch(()=>{});
        } else {
            player.pause();
            docV.pause();
            setAudioIconState(true);
        }
    }

    // فيديو الشرح فقط (صامت)
    function toggleProdVid() {
        if (prodV.paused) {
            prodV.play().then(()=> setVidIconState(false)).catch(()=>{});
        } else {
            prodV.pause();
            setVidIconState(true);
        }
    }

    function openWA() {
        document.getElementById('wa-modal').style.display = 'flex';
    }
    function closeWA() {
        document.getElementById('wa-modal').style.display = 'none';
        document.getElementById('wa-done').style.display = 'none';
    }

    function sendWA() {
        const phone = document.getElementById('user-phone').value;
        const btn = document.getElementById('send-wa-btn');

        if (!phone) { alert("يرجى إدخال رقم الجوال أولاً"); return; }

        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري الإرسال...';

        fetch("{{ url('send-whatsapp') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                phone: phone,
                message: currentAnswerContent,
                question_title: currentQuestionTitle
            })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                document.getElementById('wa-done').style.display = 'block';
                setTimeout(closeWA, 2000);
            }
        })
        .finally(() => {
            btn.disabled = false;
            btn.innerHTML = 'إرسال الآن';
        });
    }

    function resetFlow() {
        document.body.classList.remove('active');

        try { player.pause(); } catch(e){}
        try { docV.pause(); } catch(e){}
        try { prodV.pause(); } catch(e){}

        answerSec.style.opacity = '0';
        setTimeout(() => { answerSec.style.display = 'none'; }, 500);

        document.querySelectorAll('.media-card').forEach(card => card.style.display = 'none');

        setAudioIconState(true);
        setVidIconState(true);
    }

    // سحب فيديو الدكتور على الجوال
    const dragItem = document.getElementById("doc-mini-card");
    let xOffset = 0, yOffset = 0, initialX, initialY, activeDrag = false;

    dragItem.addEventListener("touchstart", (e) => { 
        initialX = e.touches[0].clientX - xOffset; 
        initialY = e.touches[0].clientY - yOffset; 
        activeDrag = true; 
    }, false);

    dragItem.addEventListener("touchend", () => activeDrag = false, false);

    dragItem.addEventListener("touchmove", (e) => {
        if (activeDrag) {
            e.preventDefault();
            let currentX = e.touches[0].clientX - initialX;
            let currentY = e.touches[0].clientY - initialY;
            xOffset = currentX; 
            yOffset = currentY;
            dragItem.style.transform = `translate3d(${currentX}px, ${currentY}px, 0)`;
        }
    }, false);
</script>

</body>
</html>
