@extends('layouts.admin')

@section('content')
<div class="card shadow border-0 p-4">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-user-plus me-2"></i> إضافة موظف جديد</h4>

    <form action="{{ route('admin.users.store') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label fw-bold">الاسم الكامل</label>
                <input type="text" name="name" class="form-control rounded-3" required>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label fw-bold">البريد الإلكتروني</label>
                <input type="email" name="email" class="form-control rounded-3" required>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label fw-bold">كلمة المرور</label>
                <input type="password" name="password" class="form-control rounded-3" required>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label fw-bold">تأكيد كلمة المرور</label>
                <input type="password" name="password_confirmation" class="form-control rounded-3" required>
            </div>
            <div class="col-md-12 mb-4">
                <label class="form-label fw-bold">نوع الصلاحية</label>
                <select name="role" class="form-select rounded-3">
                    <option value="editor">محرر (إدارة الأسئلة والأجوبة فقط)</option>
                    <option value="admin">مدير نظام (كامل الصلاحيات)</option>
                </select>
            </div>
        </div>
        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary px-5 rounded-pill fw-bold">حفظ الموظف</button>
            <a href="{{ route('admin.users.index') }}" class="btn btn-light px-5 rounded-pill">إلغاء</a>
        </div>
    </form>
</div>
@endsection