@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="main-card bg-white p-4 shadow-sm rounded-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="fw-bold text-primary mb-0">قائمة الأسئلة والاستشارات</h3>
            <a href="{{ route('admin.questions.create') }}" class="btn btn-primary rounded-pill px-4">
                <i class="fas fa-plus ms-1"></i> إضافة سؤال جديد
            </a>
        </div>

        @if(session('success'))
            <div class="alert alert-success border-0 shadow-sm rounded-3">
                <i class="fas fa-check-circle ms-2"></i> {{ session('success') }}
            </div>
        @endif

        <div class="table-responsive">
            <table class="table table-hover align-middle border-top">
                <thead class="bg-light">
                    <tr>
                        <th class="text-center" width="80">الترتيب</th>
                        <th>نص السؤال</th>
                        <th class="text-center">الوسائط المتوفرة</th>
                        <th class="text-center" width="180">الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($questions as $q)
                    <tr>
                        <td class="text-center fw-bold text-secondary">{{ $q->sort_order }}</td>
                        <td>{{ \Illuminate\Support\Str::limit($q->title, 60) }}</td>
                        <td class="text-center">
                            @if($q->answer->image_path) <i class="fas fa-image text-primary mx-1" title="صورة"></i> @endif
                            @if($q->answer->video_path) <i class="fas fa-video text-success mx-1" title="فيديو"></i> @endif
                            @if($q->answer->audio_path) <i class="fas fa-microphone text-info mx-1" title="صوت"></i> @endif
                            @if($q->answer->response_video_path) <i class="fas fa-user-md text-danger mx-1" title="فيديو الدكتور"></i> @endif
                        </td>
                        <td class="text-center">
                            <div class="d-flex justify-content-center gap-2">
                                <a href="{{ route('admin.questions.edit', $q->id) }}" class="btn btn-sm btn-outline-info rounded-pill px-3">
                                    <i class="fas fa-edit"></i> تعديل
                                </a>
                                
                                <form action="{{ route('admin.questions.destroy', $q->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا السؤال نهائياً؟')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger rounded-pill px-3">
                                        <i class="fas fa-trash"></i> حذف
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection