@extends('layouts.admin')

@section('content')
<style>
    :root { --primary-blue: #007bff; --glass-bg: rgba(255, 255, 255, 0.9); }
    body { background: #f0f2f5; font-family: 'Segoe UI', sans-serif; }
    .main-card { 
        background: var(--glass-bg); backdrop-filter: blur(10px); 
        border-radius: 20px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.08);
        padding: 30px; margin-top: 20px;
    }
    .input-group-custom { 
        background: #fff; border: 1.5px solid #e0e0e0; border-radius: 12px; 
        padding: 10px; transition: 0.3s; margin-bottom: 20px;
    }
    .input-group-custom:focus-within { border-color: var(--primary-blue); }
    .section-title { border-right: 5px solid var(--primary-blue); padding-right: 15px; color: var(--primary-blue); font-weight: 800; }
    .upload-box {
        border: 2px dashed #cbd5e0; border-radius: 15px; padding: 20px;
        text-align: center; cursor: pointer; background: #fafafa; position: relative;
    }
    .current-badge { position: absolute; top: 10px; left: 10px; font-size: 0.7rem; padding: 3px 8px; border-radius: 20px; }
    .preview-img { max-width: 100%; max-height: 80px; margin-top: 10px; border-radius: 8px; display: block; margin-left: auto; margin-right: auto; }
</style>

<div class="container pb-5">
    <div class="main-card">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="section-title mb-0">تعديل السؤال: {{ $question->title }}</h4>
            <a href="{{ route('admin.questions.index') }}" class="btn btn-outline-secondary btn-sm">إلغاء والعودة</a>
        </div>
        
        <form action="{{ route('admin.questions.update', $question->id) }}" method="POST" enctype="multipart/form-data" id="editForm">
            @csrf
            @method('PUT')
            
            <div class="row">
                <div class="col-md-5">
                    <label class="fw-bold mb-2">نص السؤال</label>
                    <div class="input-group-custom">
                        <input type="text" name="title" class="form-control border-0" value="{{ $question->title }}" required>
                    </div>
                </div>

                <div class="col-md-4">
                    <label class="fw-bold mb-2 text-success"><i class="fab fa-whatsapp ms-1"></i> رقم جوال العميل (للإرسال التلقائي)</label>
                    <div class="input-group-custom" style="border-color: #28a745;">
                        <input type="text" name="phone" class="form-control border-0" value="{{ $question->phone }}" placeholder="9665xxxxxxxx">
                    </div>
                </div>

                <div class="col-md-3">
                    <label class="fw-bold mb-2">الترتيب</label>
                    <div class="input-group-custom">
                        <input type="number" name="sort_order" class="form-control border-0" value="{{ $question->sort_order }}">
                    </div>
                </div>

                <div class="col-12 mt-3">
                    <label class="fw-bold mb-2">نص الإجابة (سيتم إرساله للعميل عبر واتساب)</label>
                    <div class="input-group-custom">
                        <textarea name="content" class="form-control border-0" rows="5" required>{{ $question->answer->content }}</textarea>
                    </div>
                </div>

                <div class="col-md-4 mt-4">
                    <label class="form-label">صورة المنتج</label>
                    <div class="upload-box" onclick="document.getElementById('img_input').click()">
                        @if($question->answer->image_path)
                            <span class="current-badge bg-success text-white">يوجد صورة حالية</span>
                            <img src="{{ asset('storage/' . $question->answer->image_path) }}" id="img_preview" class="preview-img">
                        @else
                            <i class="fas fa-image fa-2x mb-2 text-primary"></i>
                            <img id="img_preview" class="preview-img" style="display:none">
                        @endif
                        <p class="mb-0 small text-muted">اضغط لتغيير الصورة</p>
                        <input type="file" id="img_input" name="image_path" hidden accept="image/*" onchange="previewFile(this, 'img')">
                    </div>
                </div>

                <div class="col-md-4 mt-4">
                    <label class="form-label">فيديو الشرح</label>
                    <div class="upload-box" onclick="document.getElementById('vid_input').click()">
                        @if($question->answer->video_path)
                            <span class="current-badge bg-info text-white">يوجد فيديو حالي</span>
                        @endif
                        <i class="fas fa-video fa-2x mb-2 text-success"></i>
                        <p id="vid_status" class="mb-0 small text-muted">اضغط لتغيير الفيديو</p>
                        <input type="file" id="vid_input" name="video_path" hidden accept="video/*" onchange="updateLabel(this, 'vid_status')">
                    </div>
                </div>

                <div class="col-md-4 mt-4">
                    <label class="form-label">الملف الصوتي</label>
                    <div class="upload-box" onclick="document.getElementById('aud_input').click()">
                        @if($question->answer->audio_path)
                            <span class="current-badge bg-warning text-dark">يوجد ملف صوتي</span>
                        @endif
                        <i class="fas fa-microphone fa-2x mb-2 text-info"></i>
                        <p id="aud_status" class="mb-0 small text-muted">اضغط لتغيير الصوت</p>
                        <input type="file" id="aud_input" name="audio_path" hidden accept="audio/*" onchange="updateLabel(this, 'aud_status')">
                    </div>
                </div>
            </div>

            <div class="text-center mt-5">
                <button type="submit" class="btn btn-primary px-5 py-2 rounded-pill fw-bold" id="submitBtn">
                    <i class="fas fa-paper-plane ms-2"></i> حفظ الإجابة وإرسال واتساب
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function previewFile(input, type) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById(type + '_preview');
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(input.files[0]);
    }
}

function updateLabel(input, statusId) {
    if (input.files && input.files[0]) {
        document.getElementById(statusId).textContent = "تم اختيار: " + input.files[0].name;
        document.getElementById(statusId).classList.add('text-primary', 'fw-bold');
    }
}

document.getElementById('editForm').onsubmit = function() {
    const btn = document.getElementById('submitBtn');
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري الحفظ والإرسال...';
    btn.disabled = true;
};
</script>
@endsection