@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <h3 class="fw-bold mb-4 text-primary">لوحة الإحصائيات السريعة</h3>
    
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm rounded-4 p-3 bg-primary text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">إجمالي الأسئلة</h6>
                        <h2 class="fw-bold mb-0">{{ $questionsCount }}</h2>
                    </div>
                    <i class="fas fa-question-circle fa-3x opacity-50"></i>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-0 shadow-sm rounded-4 p-3 bg-success text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">طلبات الاستشارة (واتساب)</h6>
                        <h2 class="fw-bold mb-0">{{ $leadsCount }}</h2>
                    </div>
                    <i class="fab fa-whatsapp fa-3x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-5">
        <h5 class="fw-bold mb-3">أحدث أرقام العملاء المهتمين</h5>
        <div class="card border-0 shadow-sm rounded-4">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th>الجوال</th>
                        <th>تاريخ الطلب</th>
                        <th>نص الاستشارة</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($latestLeads as $lead)
                    <tr>
                        <td class="fw-bold text-success">{{ $lead->phone }}</td>
                        <td>{{ $lead->created_at->format('Y-m-d H:i') }}</td>
                        <td>{{ Str::limit($lead->consultation_text, 50) }}</td>
                    </tr>
                    @empty
                    <tr><td colspan="3" class="text-center text-muted p-4">لا توجد طلبات تواصل حتى الآن</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection