@extends('layouts.admin')

@section('content')
<style>
    :root { --primary-blue: #007bff; --glass-bg: rgba(255, 255, 255, 0.9); }
    body { background: #f0f2f5; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
    .main-card { 
        background: var(--glass-bg); backdrop-filter: blur(10px); 
        border-radius: 20px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.08);
        padding: 30px; margin-top: 20px;
    }
    .form-label { font-weight: 700; color: #444; margin-bottom: 10px; display: block; }
    .input-group-custom { 
        background: #fff; border: 1.5px solid #e0e0e0; border-radius: 12px; 
        padding: 10px; transition: 0.3s; margin-bottom: 20px;
    }
    .input-group-custom:focus-within { border-color: var(--primary-blue); box-shadow: 0 0 0 4px rgba(0,123,255,0.1); }
    .input-control { border: none; width: 100%; outline: none; font-size: 1rem; }
    .section-title { 
        border-right: 5px solid var(--primary-blue); padding-right: 15px; 
        margin-bottom: 25px; color: var(--primary-blue); font-weight: 800;
    }
    .upload-box {
        border: 2px dashed #cbd5e0; border-radius: 15px; padding: 20px;
        text-align: center; cursor: pointer; transition: 0.3s; background: #fafafa;
        position: relative; overflow: hidden; height: 100%;
    }
    .upload-box:hover { background: #f1f7ff; border-color: var(--primary-blue); }
    .preview-img { max-width: 100%; max-height: 100px; display: none; margin-top: 10px; border-radius: 8px; margin-left: auto; margin-right: auto; }
    .file-name { font-size: 0.75rem; color: #007bff; display: block; margin-top: 8px; font-weight: bold; }
    .btn-save { 
        background: linear-gradient(45deg, #007bff, #0056b3); color: white; 
        border: none; padding: 12px 40px; border-radius: 50px; font-weight: bold;
        box-shadow: 0 5px 15px rgba(0,123,255,0.3); transition: 0.3s;
    }
</style>

<div class="container pb-5">
    <div class="main-card">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="section-title mb-0">إضافة سؤال واستشارة جديدة</h4>
            <a href="{{ route('admin.questions.index') }}" class="btn btn-outline-primary rounded-pill px-4">
                <i class="fas fa-list-ul ms-1"></i> عرض كافة الأسئلة
            </a>
        </div>
        
        <form action="{{ route('admin.questions.store') }}" method="POST" enctype="multipart/form-data" id="questionForm">
            @csrf
            
            <div class="row">
                <div class="col-md-6">
                    <label class="form-label">نص السؤال</label>
                    <div class="input-group-custom">
                        <input type="text" name="title" class="input-control" placeholder="مثال: ما هي مميزات مرتبة إيميليا؟" required>
                    </div>
                </div>
<div class="mb-3">
    <label class="form-label fw-bold">رقم جوال العميل (مثال: 9665xxxxxxxx)</label>
    <input type="text" name="phone" class="form-control" placeholder="966508071893" required>
</div>
                <div class="col-md-6">
                    <label class="form-label">ترتيب الظهور</label>
                    <div class="input-group-custom">
                        <input type="number" name="sort_order" class="input-control" value="0">
                    </div>
                </div>

                <div class="col-12 mt-3">
                    <label class="form-label">نص الإجابة</label>
                    <div class="input-group-custom">
                        <textarea name="content" class="input-control" rows="5" placeholder="اكتب كل نقطة في سطر منفصل..." required></textarea>
                    </div>
                </div>

                <div class="col-12 mt-4">
                    <h5 class="fw-bold mb-3 text-secondary"><i class="fas fa-photo-video ms-2"></i> وسائط المنتج</h5>
                </div>

                <div class="col-md-4 mb-4">
                    <label class="form-label">صورة المنتج</label>
                    <div class="upload-box" onclick="document.getElementById('img_input').click()">
                        <i class="fas fa-image fa-2x mb-2 text-primary"></i>
                        <p class="mb-0 small">اضغط لرفع صورة</p>
                        <img id="img_preview" class="preview-img">
                        <span id="img_name" class="file-name"></span>
                        <input type="file" id="img_input" name="image_path" hidden accept="image/*" onchange="previewFile(this, 'img')">
                    </div>
                </div>

                <div class="col-md-4 mb-4">
                    <label class="form-label">فيديو الشرح</label>
                    <div class="upload-box" onclick="document.getElementById('vid_input').click()">
                        <i class="fas fa-video fa-2x mb-2 text-success"></i>
                        <p class="mb-0 small">اضغط لرفع فيديو</p>
                        <span id="vid_name" class="file-name"></span>
                        <input type="file" id="vid_input" name="video_path" hidden accept="video/*" onchange="previewFile(this, 'vid')">
                    </div>
                </div>

                <div class="col-md-4 mb-4">
                    <label class="form-label">الملف الصوتي</label>
                    <div class="upload-box" onclick="document.getElementById('aud_input').click()">
                        <i class="fas fa-microphone fa-2x mb-2 text-info"></i>
                        <p class="mb-0 small">اضغط لرفع صوت</p>
                        <span id="aud_name" class="file-name"></span>
                        <input type="file" id="aud_input" name="audio_path" hidden accept="audio/*" onchange="previewFile(this, 'aud')">
                    </div>
                </div>

                <div class="col-12">
                    <label class="form-label text-danger">فيديو استجابة الدكتور (يظهر بشكل مصغر)</label>
                    <div class="upload-box py-3" onclick="document.getElementById('doc_vid_input').click()">
                        <i class="fas fa-user-md fa-2x mb-2 text-danger"></i>
                        <p class="mb-0 small">اضغط لرفع فيديو الطبيب</p>
                        <span id="doc_vid_name" class="file-name"></span>
                        <input type="file" id="doc_vid_input" name="response_video_path" hidden accept="video/*" onchange="previewFile(this, 'doc_vid')">
                    </div>
                </div>
            </div>

            <div class="text-center mt-5">
                <button type="submit" class="btn-save" id="submitBtn">
                    <i class="fas fa-save ms-2"></i> حفظ البيانات ونشرها
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function previewFile(input, type) {
    if (input.files && input.files[0]) {
        const fileName = input.files[0].name;
        document.getElementById(type + '_name').textContent = "✓ تم اختيار: " + fileName;

        // معاينة الصورة فقط
        if (type === 'img') {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('img_preview');
                preview.src = e.target.result;
                preview.style.display = 'block';
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
}

document.getElementById('questionForm').onsubmit = function() {
    const btn = document.getElementById('submitBtn');
    btn.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i> جاري معالجة ورفع الملفات...';
    btn.style.opacity = '0.8';
    btn.disabled = true;
};
</script>
@endsection