@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="card border-0 shadow-sm rounded-4 p-4">
        <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-user-shield ms-2"></i> تأمين حساب الإدارة</h4>
        
        @if(session('success'))
            <div class="alert alert-success border-0 rounded-3 mb-4">{{ session('success') }}</div>
        @endif

        <form action="{{ route('admin.profile.update') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-bold">البريد الإلكتروني للإدارة</label>
                    <input type="email" name="email" class="form-control rounded-3" value="{{ auth()->user()->email }}" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-bold">كلمة المرور الجديدة</label>
                    <input type="password" name="password" class="form-control rounded-3" placeholder="اتركها فارغة إذا لم ترد التغيير">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-bold">تأكيد كلمة المرور</label>
                    <input type="password" name="password_confirmation" class="form-control rounded-3">
                </div>
            </div>
            <button type="submit" class="btn btn-primary px-5 rounded-pill fw-bold mt-3">تحديث بيانات الأمان</button>
        </form>
    </div>
</div>
@endsection