@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <h3 class="fw-bold mb-4" style="color: #ffffff;">لوحة الإحصائيات الذكية</h3>
    
    <div class="row g-4 mb-5">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-secondary fw-bold mb-1">إجمالي الأسئلة</h6>
                        <h2 class="fw-bold mb-0" style="color: var(--primary-color);">{{ $questionsCount }}</h2>
                    </div>
                    <div class="rounded-circle p-3" style="background: var(--primary-color); color: white;">
                        <i class="fas fa-question-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-secondary fw-bold mb-1">طلبات الاستشارة (واتساب)</h6>
                        <h2 class="fw-bold mb-0 text-success">{{ $leadsCount }}</h2>
                    </div>
                    <div class="rounded-circle p-3 bg-success text-white">
                        <i class="fab fa-whatsapp fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-md-12">
            <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
                <h5 class="fw-bold mb-4" style="color: #2d3436;">
                    <i class="fas fa-chart-area me-2" style="color: var(--primary-color);"></i>تحليل نمو طلبات الاستشارة (آخر 7 أيام)
                </h5>
                <canvas id="leadsChart" height="100"></canvas>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm rounded-4 p-4" style="background: rgba(255, 255, 255, 0.9);">
        <h5 class="fw-bold mb-3" style="color: #2d3436;">أحدث طلبات الاستشارة</h5>
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="bg-light">
                    <tr>
                        <th style="color: #636e72;">رقم الجوال</th>
                        <th style="color: #636e72;">تاريخ الطلب</th>
                        <th style="color: #636e72;">نص الاستشارة</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($latestLeads as $lead)
                    <tr>
                        <td class="fw-bold text-success">{{ $lead->phone }}</td>
                        <td class="text-dark">{{ $lead->created_at->format('Y-m-d H:i') }}</td>
                        <td class="text-secondary">{{ Str::limit($lead->consultation_text, 50) }}</td>
                    </tr>
                    @empty
                    <tr><td colspan="3" class="text-center p-4 text-muted">لا توجد بيانات حالياً</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('leadsChart').getContext('2d');
    const leadsChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: {!! json_encode($chartLabels) !!},
            datasets: [{
                label: 'عدد الطلبات',
                data: {!! json_encode($chartValues) !!},
                borderColor: '{{ $settings->primary_color ?? "#28a745" }}',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4,
                pointBackgroundColor: '{{ $settings->primary_color ?? "#28a745" }}',
                pointRadius: 4
            }]
        },
        options: {
            responsive: true,
            plugins: { 
                legend: { display: false },
                tooltip: {
                    titleFont: { family: 'AppCustomFont' },
                    bodyFont: { family: 'AppCustomFont' }
                }
            },
            scales: {
                y: { 
                    beginAtZero: true, 
                    ticks: { stepSize: 1, color: '#636e72' },
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: { 
                    ticks: { color: '#636e72' },
                    grid: { display: false } 
                }
            }
        }
    });
</script>
@endsection