<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Question;

class QuestionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Question::create([
            'category' => 'general',
            'question_text' => 'ما هو تخصص هذا البنك؟',
            'answer_text' => 'أهلاً بك! نحن متخصصون في تقديم المعلومات الدقيقة حول مشروعك الجديد.',
            'audio_file' => 'welcome.mp3',
            'mascot_pose' => 'wave'
        ]);

        Question::create([
            'category' => 'technical',
            'question_text' => 'كيف يعمل الذكاء الاصطناعي هنا؟',
            'answer_text' => 'أقوم حالياً بالرد من خلال بنك أسئلة معد مسبقاً، وقريباً سأتمكن من فهمك بشكل أعمق.',
            'audio_file' => 'ai_info.mp3',
            'mascot_pose' => 'thinking'
        ]);
    }
} // تأكد من وجود هذا القوس في النهاية