<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('settings', function (Blueprint $table) {
        $table->id();
        $table->string('intro_video_path')->nullable(); // مسار فيديو المقدمة
        $table->string('intro_bg_color')->default('#ffffff'); // لون خلفية المقدمة
        $table->string('primary_color')->default('#007bff'); // اللون الأساسي للنظام
        $table->string('font_family')->default("'Segoe UI', sans-serif"); // الخط
        $table->string('bg_color')->default('#f4f7f6'); // خلفية النظام العامة
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
