<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('questions', function (Blueprint $table) {
        $table->id();
        $table->string('category')->nullable(); // تصنيف السؤال
        $table->text('question_text');          // نص السؤال 
        $table->text('answer_text');            // نص الرد (المكتوب)
        $table->string('audio_file')->nullable(); // اسم أو مسار ملف الصوت
        $table->string('mascot_pose')->default('happy'); // حركة التميمة (happy, thinking, wave)
        $table->timestamps(); // تاريخ الإنشاء والتحديث
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('questions');
    }
};
