<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    /**
     * الحقول القابلة للتعبئة بشكل جماعي.
     * تم إضافة حقول إعدادات WhatsApp API للتحكم الكامل من لوحة الإدارة.
     */
    protected $fillable = [
        // إعدادات المظهر والهوية
        'intro_video_path', 
        'intro_bg_color', 
        'primary_color', 
        'font_family', 
        'custom_font',     
        'bg_type',         
        'bg_color',        
        'bg_gradient_end', 
        'bg_image',        
        'doctor_mini_size',

        // إعدادات WhatsApp API الجديدة
        'wa_api_url',          // رابط مزود الخدمة
        'wa_instance_id',      // معرف النسخة (Instance ID)
        'wa_token',            // رمز الوصول (Token)
        'wa_message_template', // قالب الرسالة الديناميكي
        'wa_default_link',     // الرابط الافتراضي الملحق بالرسالة
        'wa_enabled'           // مفتاح تفعيل/تعطيل الإرسال التلقائي
    ];

    /**
     * دالة مساعدة للحصول على رابط الفيديو بشكل مباشر.
     */
    public function getIntroVideoUrlAttribute()
    {
        return $this->intro_video_path 
            ? asset('storage/' . $this->intro_video_path) 
            : asset('assets/video/dr-back-care-intro.mp4');
    }
}