<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Question; 
use App\Models\Answer;   
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Artisan;

class SettingController extends Controller
{
    public function index()
    {
        $settings = Setting::first() ?? new Setting();
        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request) {
        $settings = Setting::updateOrCreate(['id' => 1]);

        // معالجة الخط
        if ($request->hasFile('custom_font')) {
            $fontFile = $request->file('custom_font');
            $fontName = 'font_' . time() . '.' . $fontFile->getClientOriginalExtension();
            $fontFile->move(public_path('assets/fonts'), $fontName);
            $settings->custom_font = $fontName;
            $settings->font_family = $fontName;
        }
        
        // حفظ بيانات الهوية البصرية
        $settings->bg_type = $request->bg_type;
        $settings->bg_color = ($request->bg_type == 'gradient') ? $request->bg_color_grad_start : $request->bg_color;
        $settings->bg_gradient_end = $request->bg_gradient_end;
        $settings->primary_color = $request->primary_color;

        // --- إصلاح حفظ حالة التفعيل ---
        // بما أن الحقل متكرر في الواجهة، نستخدم collect للحصول على آخر قيمة مرسلة وضمان الحفظ
        $settings->wa_enabled = $request->has('wa_enabled') ? 1 : 0;

        // حفظ باقي إعدادات الواتساب
        $settings->wa_api_url = $request->wa_api_url ?? '';
        $settings->wa_instance_id = $request->wa_instance_id ?? '';
        $settings->wa_token = $request->wa_token ?? '';
        $settings->wa_message_template = $request->wa_message_template ?? 'إليك إجابة استفسارك: {answer}';
        $settings->wa_default_link = $request->wa_default_link ?? '';

        $settings->save(); 

        // تحديث طابع الوقت لكافة السجلات لتنشيط القالب الجديد فوراً
        Question::query()->touch();
        Answer::query()->touch();

        Artisan::call('view:clear');
        
        return back()->with('success', 'تم حفظ الإعدادات وتحديث قائمة الأسئلة بنجاح!');
    }
}