<?php

namespace App\Filament\Resources;

use App\Filament\Resources\QuestionResource\Pages;
use App\Models\Question;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ImageColumn;

class QuestionResource extends Resource
{
    protected static ?string $model = Question::class;

    // تغيير الأيقونة لتناسب الأسئلة
    protected static ?string $navigationIcon = 'heroicon-o-question-mark-circle';
    
    // اسم المورد في القائمة الجانبية باللغة العربية
    protected static ?string $navigationLabel = 'بنك الأسئلة';
    protected static ?string $pluralModelLabel = 'الأسئلة';
    protected static ?string $modelLabel = 'سؤال';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('محتوى السؤال والرد')
                    ->description('أدخل نص السؤال والإجابة التي ستظهر في الفقاعة النصية')
                    ->schema([
                        TextInput::make('question_text')
                            ->label('نص السؤال')
                            ->required()
                            ->placeholder('مثلاً: ما هي أفضل مرتبة لآلام الظهر؟'),
                        Textarea::make('answer_text')
                            ->label('نص الإجابة (الفقاعة)')
                            ->required()
                            ->rows(3),
                    ])->columns(1),

                Section::make('الوسائط المتعددة')
                    ->description('ارفع الملفات الخاصة بالنطق والتميمة لهذا الرد')
                    ->schema([
                        FileUpload::make('audio_path')
                            ->label('ملف صوت الرد')
                            ->directory('audio')
                            ->acceptedFileTypes(['audio/mpeg', 'audio/wav', 'audio/mp3'])
                            ->preserveFilenames(),
                        
                        FileUpload::make('image')
                            ->label('صورة توضيحية')
                            ->image()
                            ->directory('answers/images'),
                            
                        FileUpload::make('video')
                            ->label('فيديو الرد (التميمة)')
                            ->directory('answers/videos')
                            ->acceptedFileTypes(['video/mp4', 'video/quicktime'])
                            ->preserveFilenames(),
                    ])->columns(3),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')->label('ID')->sortable(),
                TextColumn::make('question_text')
                    ->label('السؤال')
                    ->searchable()
                    ->limit(50),
                TextColumn::make('answer_text')
                    ->label('الإجابة')
                    ->limit(50),
                ImageColumn::make('image')
                    ->label('الصورة'),
                TextColumn::make('created_at')
                    ->label('تاريخ الإضافة')
                    ->dateTime('Y-m-d')
                    ->sortable(),
            ])
            ->filters([
                // يمكنك إضافة فلاتر هنا لاحقاً
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListQuestions::route('/'),
            'create' => Pages\CreateQuestion::route('/create'),
            'edit' => Pages\EditQuestion::route('/{record}/edit'),
        ];
    }
}